\version "2.18.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 23))
  markup-system-spacing = #'((basic-distance . 30))
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 8\mm
  %ragged-right = ##f
  %ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Am văzut lumina"
  subtitle = "glasul 1"
  %subsubtitle = "Op. 21"
  %poet = "Vasile Militaru (1885 - 1959)"
  composer =  "arm. după N. Lungu"
  %arranger = "io"
  %meter = "Allegretto"
  tagline=""
}

global = {
  \key f \major
  \autoBeamOn
  %\cadenzaOn
  \time 2/4
  %\partial 8.
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Am vă -- zut lu -- mi -- na cea a -- de -- vă -- ra -- tă,
  am pri -- mit Du -- hul cel ce -- resc,
  am a -- flat cre -- din -- ţa cea a -- de -- vă -- ra -- tă,
  ne -- des -- păr -- ţi -- tei Sfin -- tei Tre -- imi în -- chi -- nân -- du -- ne,
  că a -- ceas -- ta ne-a mân -- tu -- it pe noi.  
  Doam -- ne mi -- lu -- ieş -- te.
  Doam -- ne mi -- lu -- ieş -- te.
  Ți -- e, Doam -- ne. A -- min.
  În -- tru nu -- me -- le Dom -- nu -- lui. 
}

menWords = \womenWords

sopMusic = \relative c' {
  d4^\mf d g g a( g) f( e) g f f8([ e]) d4 e( f)
  d2 \breathe d4 d e( f) g f e f g2 \breathe
  f4 g a b a( g) f( e) g f f8([ e]) d4 e( f) d4. \breathe 
  c8 d4 e f e f( g) f e d2 
  c4 c f e d2 \breathe d4 d g2 f4 e f g f2 e d \fermata 
  \bar "|."
}

altMusic = \relative c' {
  d4 d g g a( g) f( e) e f f8([ e]) d4 e( f)
  d2 d4 d e( f) g f e f g2 
  f4 g a b a( g) f( e) e f f8([ e]) d4 e( f) d4. 
  c8 d4 e f e f( g) f e d2 
  c4 c f e d2 d4 d g2 f4 e d e f2 c d 
}

bassMusic = \relative c {
  d4 d g g f( g) f( c) c d d d a2 d 
  d4 d e( d) g f e f g2
  f4 g a g a( g) f( c) c d d d a2 d4.
  c8 d4 e f e f( g) f e d2 c4 c f e d2
  d4 d g2 f4 e d c f2 c d
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
      >>
    
    \new Staff <<
      \clef bass
      \new Voice { \global \bassMusic }
      %\new Voice { \voiceOne \global \tenorMusic }
      %\new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 50
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}